/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.client.hud.element;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import wayoftime.bloodmagic.client.Sprite;
import wayoftime.bloodmagic.client.hud.element.HUDElement;
import wayoftime.bloodmagic.common.item.BloodMagicItems;
import wayoftime.bloodmagic.common.item.sigil.ItemSigilHolding;

public class ElementHolding
extends HUDElement {
    private static final Sprite HOLDING_BAR = new Sprite(new ResourceLocation("bloodmagic", "textures/gui/widgets.png"), 0, 0, 102, 22);
    private static final Sprite SELECTED_OVERLAY = new Sprite(new ResourceLocation("bloodmagic", "textures/gui/widgets.png"), 0, 22, 24, 24);

    public ElementHolding() {
        super(HOLDING_BAR.getTextureWidth(), HOLDING_BAR.getTextureHeight());
    }

    @Override
    public void draw(PoseStack matrixStack, float partialTicks, int drawX, int drawY) {
        matrixStack.m_85836_();
        HOLDING_BAR.draw(matrixStack, drawX, drawY);
        Minecraft minecraft = Minecraft.m_91087_();
        ItemStack sigilHolding = minecraft.f_91074_.m_21205_();
        if (sigilHolding.m_41720_() != BloodMagicItems.HOLDING_SIGIL.get()) {
            sigilHolding = minecraft.f_91074_.m_21206_();
        }
        if (sigilHolding.m_41720_() != BloodMagicItems.HOLDING_SIGIL.get()) {
            return;
        }
        int currentSlot = ItemSigilHolding.getCurrentItemOrdinal(sigilHolding);
        SELECTED_OVERLAY.draw(matrixStack, drawX - 1 + currentSlot * 20, drawY - 1);
        Lighting.m_84930_();
        NonNullList<ItemStack> inventory = ItemSigilHolding.getInternalInventory(sigilHolding);
        int xOffset = 0;
        for (ItemStack stack : inventory) {
            this.renderHotbarItem(matrixStack, drawX + 3 + xOffset, drawY + 3, partialTicks, (Player)minecraft.f_91074_, stack);
            xOffset += 20;
        }
        matrixStack.m_85849_();
    }

    @Override
    public boolean shouldRender(Minecraft minecraft) {
        ItemStack sigilHolding = minecraft.f_91074_.m_21205_();
        if (sigilHolding.m_41720_() != BloodMagicItems.HOLDING_SIGIL.get()) {
            sigilHolding = minecraft.f_91074_.m_21206_();
        }
        return sigilHolding.m_41720_() == BloodMagicItems.HOLDING_SIGIL.get();
    }

    protected void renderHotbarItem(PoseStack matrixStack, int x, int y, float partialTicks, Player player, ItemStack stack) {
        if (!stack.m_41619_()) {
            float animation = (float)stack.m_41612_() - partialTicks;
            if (animation > 0.0f) {
                matrixStack.m_85836_();
                float f1 = 1.0f + animation / 5.0f;
                matrixStack.m_85837_((double)(x + 8), (double)(y + 12), 0.0);
                matrixStack.m_85841_(1.0f / f1, (f1 + 1.0f) / 2.0f, 1.0f);
                matrixStack.m_85837_((double)(-(x + 8)), (double)(-(y + 12)), 0.0);
            }
            Minecraft.m_91087_().m_91291_().m_174229_((LivingEntity)player, stack, x, y, 1);
            if (animation > 0.0f) {
                matrixStack.m_85849_();
            }
            Minecraft.m_91087_().m_91291_().m_115169_(Minecraft.m_91087_().f_91062_, stack, x, y);
        }
    }
}

